# 2.创建公共应用程序

Shoplazza 要求应用程序必须先完成 OAuth 2.0 认证，然后才能使用 Shoplazza Open API 资源。因此，在应用开发阶段，您需要创建一个公共应用程序。

## 创建应用程序名称

1. 登录您的[合作伙伴账户](https://partners.shoplazza.com/)，导航至合作伙伴控制台。从左侧面板选择 **"Apps"** 选项，然后点击 **"Create app"** 按钮。

2. 在这里您将添加应用程序名称并点击创建。

> **注意**
> 应用程序名称作为应用程序实体的代表，是系统在后端处理逻辑中使用的唯一标识符。此名称通常不会在应用市场或店铺的应用程序安装列表中显示。

3. 应用程序创建后，您的客户端 ID 和客户端密钥将自动生成，可以从应用程序设置页面访问。

## 应用程序设置

在您的开发店铺上测试应用程序之前，您需要在应用程序设置中添加 **重定向 URL**，以便您可以运行验证以解锁测试功能。

1. 要添加 **重定向 URL**，请在应用程序设置下点击设置。

2. 在这里您可以添加 **应用程序 URL** 和 **重定向 URL**。

### 配置详情：

**应用程序 URL**：主要用于建立相互信任的交互授权 URL。在商户安装应用程序之前，通过此 URL 向应用程序发送请求进行授权，并传递商店名称、商店 ID、HMAC 和安装来源等基本信息。

例如，您需要在应用程序 URL 字段中输入以下内容：
```
https://stamped-review.apps.shoplazza.com/api/auth
```

**重定向 URL**：应用程序的主页，商户安装应用程序后将访问该页面。

例如，您需要在重定向 URL 字段中输入以下内容：
```
https://stamped-review.apps.shoplazza.com/api/auth/callback
```

**嵌入式选项**：指公共应用程序部分中"如何将公共应用程序与 Shoplazza 商店集成"中描述的内容。

**事件订阅**：事件可以简单理解为一种"通知"。事件订阅意味着您正在关注某个特定的通知。开发者的事件订阅都是通过 [webhook 技术](https://www.shoplazza.dev/reference/webhook-copy) 实现的。Webhook 用于向开发者推送消息，以便他们及时了解某些业务状态并做出相应的业务处理。目前有三个版本：2020-07 和 2020-01。**通常，选择 2022-01 版本就足够了**。

有关每个版本可用的 webhook、每个 webhook 的含义以及如何使用它们的详细信息，请参阅：附录 - 完整的 Webhook 组织。

**支持的国家**：指示应用程序可以被开发者看到的地区。

## 管理列表

应用程序列表将在应用商店中显示，商户可以在其中了解应用程序的功能和安装信息。它是多语言的，目前仅支持英语和中文。

1. 从应用程序设置页面，转到应用程序列表 → 管理列表。

2. 点击开始列表以添加所需信息。

3. 在列表页面，您可以添加基本应用程序信息、列表内容、定价详情以及支持和资源。

### 列表组件：

**应用程序列表名称**：用于在应用市场中显示应用程序的名称，供商户查看和使用，具有多语言功能。相比之下，**应用程序名称**是供开发者管理应用程序使用的，并作为应用程序在系统内信息传输的唯一标识符。

**列表内容**：此功能作为应用程序的全面介绍，在应用市场中呈现给商户查看。详细描述中可以嵌入 **HTML 代码** 以增强其视觉吸引力。使用"预览"功能来可视化应用程序在市场中的外观。

**定价详情**：选择计费模式。

### 定价配置指南

选择**一个**与您的应用程序支付结构相匹配的定价模式：

| 计费类型 | 描述 |
|--------------|-------------|
| **免费** | 任何形式的费用都不收取 |
| **免费安装** | 免费安装，但功能/升级收费<br>• 免费安装 + 可变使用费用 |
| **定期收费** | 基于订阅的计费（每周/每月/每年）<br>**仅订阅**<br>• 固定周期费用<br>**订阅 + 使用量**<br>• 基础订阅费 + 可变使用费用<br>• 透明的使用量层级（例如 $1/100 封邮件） |
| **一次性付款** | 永久访问权的单次付款 |

#### 1. 免费模式
[应用程序不收取任何费用]

#### 2. 免费安装模式
[免费安装，可选择付费功能或基于使用量的费用]

#### 3. 定期收费模式

- **仅订阅**：固定周期费用（每周/每月/每年）
- **订阅 + 使用量**：基础订阅费加上透明的使用量层级的可变使用费用

#### 4. 一次性收费模式
[单次付款以获得应用程序的永久访问权]

---

*1 天前更新*